% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doccgap.R, R/doccgap.all.R, R/poccgap.R,
%   R/qoccgap.R, R/roccgap.R
\name{doccgap}
\alias{doccgap}
\alias{doccgap.all}
\alias{poccgap}
\alias{qoccgap}
\alias{roccgap}
\title{The Occupancy-Gap Distribution}
\usage{
doccgap(
  x,
  size,
  space = NULL,
  occupancy = size,
  prob = NULL,
  scale = NULL,
  log = FALSE
)

doccgap.all(
  size,
  space = NULL,
  max.occupancy = size,
  prob = NULL,
  scale = NULL,
  log = FALSE
)

poccgap(
  x,
  size,
  space = NULL,
  occupancy = size,
  prob = NULL,
  scale = NULL,
  log.p = FALSE,
  lower.tail = TRUE
)

qoccgap(
  p,
  size,
  space = NULL,
  occupancy = size,
  prob = NULL,
  scale = NULL,
  log.p = FALSE,
  lower.tail = TRUE
)

roccgap(n, size, space = NULL, occupancy = size, prob = NULL, scale = NULL)
}
\arguments{
\item{x}{vector of quantiles.}

\item{size}{The size parameter for the occupancy-gap distribution (number of balls)}

\item{space}{The space parameter for the occupancy-gap distribution (number of bins)}

\item{occupancy}{The occupancy parameter for the occupancy-gap distribution (number of occupied bins)}

\item{prob}{The probability parameter for the occupancy-gap distribution (probability of ball occupying its bin)}

\item{scale}{The scale parameter for the occupancy-gap distribution}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{max.occupancy}{The maximum occupancy parameter for the occupancy-gap distribution (number of occupied bins)}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range) then the output
will be a matrix of probabilities/log-probabilities
}
\description{
Density, distribution function, quantile function and random generation
for the Occupancy-Gap Distribution with size and scale parameters (see note).
}
\details{
\code{docc.all} returns the entire PMF.

This function computes probabilities or log-probabilities from the mass function of the occupancy-gap
distribution.  The computation method uses a recursive algorithm from the following paper:
}
\section{References}{


O'Neill, B. (forthcoming) An examination of the occupancy-gap distribution.
}

\section{Note}{


The distribution is parameterised by a \code{scale} parameter, but in applied problems in the context
of the extended occupancy problem this parameter is a function of \code{space} and \code{prob} parameters.
The function allows either parameterisation (i.e., the user can either specify the \code{scale} paramater or
both the \code{space} and \code{prob} parameters).
}

\examples{
x <- roccgap(10, 20, 2, 2, .5)
p <- poccgap(x, 20, 2, 2, .5)
stopifnot(x == qoccgap(p, 20, 2, 2, .5))
doccgap.all(20, 2, 2, .5)
}
