% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODBCResourceConnector.R
\docType{class}
\name{ODBCResourceConnector}
\alias{ODBCResourceConnector}
\title{ODBC DBI resource connector}
\format{
A R6 object of class ODBCResourceConnector
}
\description{
ODBC DBI resource connector

ODBC DBI resource connector
}
\details{
Makes a ODBC DBI connection from a resource description.
}
\section{Super class}{
\code{\link[resourcer:DBIResourceConnector]{resourcer::DBIResourceConnector}} -> \code{ODBCResourceConnector}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ODBCResourceConnector-new}{\code{ODBCResourceConnector$new()}}
\item \href{#method-ODBCResourceConnector-isFor}{\code{ODBCResourceConnector$isFor()}}
\item \href{#method-ODBCResourceConnector-createDBIConnection}{\code{ODBCResourceConnector$createDBIConnection()}}
\item \href{#method-ODBCResourceConnector-getConnectionParameters}{\code{ODBCResourceConnector$getConnectionParameters()}}
\item \href{#method-ODBCResourceConnector-clone}{\code{ODBCResourceConnector$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="closeDBIConnection"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-closeDBIConnection'><code>resourcer::DBIResourceConnector$closeDBIConnection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="getTableName"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-getTableName'><code>resourcer::DBIResourceConnector$getTableName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="readDBTable"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-readDBTable'><code>resourcer::DBIResourceConnector$readDBTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="resourcer" data-topic="DBIResourceConnector" data-id="readDBTibble"><a href='../../resourcer/html/DBIResourceConnector.html#method-DBIResourceConnector-readDBTibble'><code>resourcer::DBIResourceConnector$readDBTibble()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ODBCResourceConnector-new"></a>}}
\if{latex}{\out{\hypertarget{method-ODBCResourceConnector-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ODBCResourceConnector instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODBCResourceConnector$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A ODBCResourceConnector object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ODBCResourceConnector-isFor"></a>}}
\if{latex}{\out{\hypertarget{method-ODBCResourceConnector-isFor}{}}}
\subsection{Method \code{isFor()}}{
Check that the provided resource has a URL that locates a ODBC object: the URL scheme must start with "odbc".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODBCResourceConnector$isFor(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{The resource object to validate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ODBCResourceConnector-createDBIConnection"></a>}}
\if{latex}{\out{\hypertarget{method-ODBCResourceConnector-createDBIConnection}{}}}
\subsection{Method \code{createDBIConnection()}}{
Creates a DBI connection object from a resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODBCResourceConnector$createDBIConnection(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A DBI connection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ODBCResourceConnector-getConnectionParameters"></a>}}
\if{latex}{\out{\hypertarget{method-ODBCResourceConnector-getConnectionParameters}{}}}
\subsection{Method \code{getConnectionParameters()}}{
Get the specific ODBC driver connection string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODBCResourceConnector$getConnectionParameters(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The ODBC driver connection parameters list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ODBCResourceConnector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ODBCResourceConnector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ODBCResourceConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
