% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pc_space.R
\name{gg_featurespace}
\alias{gg_featurespace}
\title{Produces a ggplot object of two dimensional feature space.}
\usage{
gg_featurespace(object, ...)
}
\arguments{
\item{object}{Object of class \dQuote{\code{pcoddstream}}.}

\item{...}{Other plotting parameters to affect the plot.}
}
\value{
A ggplot object of two dimensional feature space.
}
\description{
Create a ggplot object of two dimensional feature space  using the first two
pricipal component returned by \code{\link{get_pc_space}}.
}
\examples{
features <- extract_tsfeatures(anomalous_stream[1:100, 1:100])
pc <- get_pc_space(features)
p <- gg_featurespace(pc)
p + ggplot2::geom_density_2d()
}
\seealso{
\code{\link{find_odd_streams}}, \code{\link{extract_tsfeatures}}, \code{\link{get_pc_space}},
\code{\link{set_outlier_threshold}}
}
