# SEARCH
#' @include AllGenerics.R
NULL

## Get next cursor
next_req <- function(resp, req) {
  cursorMark <- httr2::resp_url_query(resp, "cursorMark")
  nextCursorMark <- httr2::resp_body_json(resp)$nextCursorMark

  if (is.null(nextCursorMark) || identical(nextCursorMark, cursorMark))
    return(NULL)

  httr2::req_url_query(req, cursorMark = nextCursorMark)
}

#' @rdname hal_search
#' @export
hal_search.HALQuery <- function(query, path = "search", instance = NULL,
                                limit = 30, start = 0, cursor = FALSE,
                                max_requests = Inf, on_error = "stop",
                                progress = getOption("odyssey.progress"),
                                verbose = getOption("odyssey.verbose"), ...) {
  ## Set parameters
  query$rows <- min(limit, 10000, na.rm = TRUE)

  if (cursor) {
    ## Pagination of results
    query$sort <- "docid asc"
    query$cursorMark <- "*"

    ## Build request
    req <- hal_request(query, path = path, instance = instance)

    ## Get documents from HAL
    resp <- httr2::req_perform_iterative(
      req,
      next_req = next_req,
      max_reqs = max_requests,
      on_error = on_error,
      progress = progress
    )
    success <- httr2::resps_successes(resp)
    body <- httr2::resps_data(
      success,
      resp_data = function(resp) httr2::resp_body_json(resp)
    )
  } else {
    ## Pagination of results
    query$start <- start

    ## Build request
    req <- hal_request(query, path = path, instance = instance)

    ## Progress bar
    if (progress) req <- httr2::req_progress(req)

    ## Get documents from HAL
    resp <- httr2::req_perform(req)
    body <- httr2::resp_body_json(resp)

    if (verbose) {
      n_max <- body$response$numFound
      n_limit <- min(n_max, limit, na.rm = TRUE)
      msg <- ngettext(n_limit, "%d item out of %s were returned.",
                      "%d items out of %s were returned.")
      message(sprintf(msg, n_limit, n_max))
    }
  }

  structure(body, class = "HALSearch")
}
