% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oda_get_crs.R
\name{oda_get_crs}
\alias{oda_get_crs}
\title{Get OECD Creditor Reporting System (CRS) data}
\usage{
oda_get_crs(
  start_year = NULL,
  end_year = NULL,
  filters = NULL,
  pre_process = TRUE,
  as_grant_equivalent = FALSE
)
}
\arguments{
\item{start_year}{Integer. The starting year of the data query. If \code{NULL},
no lower bound is set. Defaults to \code{NULL}.}

\item{end_year}{Integer. The ending year of the data query. If \code{NULL},
no upper bound is set. Defaults to \code{NULL}.}

\item{filters}{List. A named list of filters to apply (e.g., donor codes,
easure, flow type, unit measure, price base). Values must match OECD dotstat
codes.}

\item{pre_process}{Logical. Whether to clean and rename columns into a
standard format. If \code{FALSE}, returns raw output. Defaults to \code{TRUE}.}

\item{as_grant_equivalent}{Logical. Whether the 'flows' or 'grant equivalent'
version of the CRS should be returned.}
}
\value{
A data frame containing OECD CRS data
}
\description{
Retrieves data from the OECD CRS dataset using specified filters, years,
and optional pre-processing.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
oda_get_crs(
  start_year = 2018,
  end_year = 2022,
  filters = list(
    donor = c("AUT", "FRA", "USA"),
    recipient = "BIH",
    measure = 100,
    channel = 60000,
    price_base = "Q"
  )
)
}
\dontshow{\}) # examplesIf}
}
