% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_numerics.R
\name{match_numerics}
\alias{match_numerics}
\title{Best-possible match of two numeric vectors}
\usage{
match_numerics(x, y)
}
\arguments{
\item{x, y}{[\code{numeric()}]\cr
Two vectors of the same length.}
}
\value{
An \code{integer} vector of length \code{length(x)} with the positions of
\code{y} in \code{x}.
}
\description{
This function matches the indices of two numeric vectors as good as possible
(that means with the smallest possible sum of deviations).
}
\examples{
x <- c(-1, 0, 1)
y <- c(0.1, 1.5, -1.2)
match_numerics(x, y)
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{equidistant_vectors}()},
\code{\link{insert_vector_entry}()},
\code{\link{map_indices}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{indexing}
