% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_within_segment_loss.R
\name{ChangePoints}
\alias{ChangePoints}
\title{Detect Number and Location of Change Points of Independent Data}
\usage{
ChangePoints(
  x,
  point_max = 5,
  penalty = "bic",
  seg_min = 1,
  num_init = NULL,
  cpp = TRUE
)
}
\arguments{
\item{x}{The data to find change points.}

\item{point_max}{The largest candidate number of change points.}

\item{penalty}{Penalty type term. Default is "bic". Users can use other penalty term.}

\item{seg_min}{Minimal segment size between change points at transformed sacle, 
must be positive integer.}

\item{num_init}{The number of repetition times, in order to avoid local
minimum. Default is squared root of number of observations. Must be integer.}

\item{cpp}{Option to accelerate using rcpp. Default is TRUE.}
}
\value{
\item{num_change_point}{optimal number of change points.}
  \item{change_point}{location of change points.}
}
\description{
Detect the number and locations of change points based on minimizing within
segment quadratic loss and applying penalized model selection approach with
restriction of largest candidate number of change points.
}
\details{
The K change points form K+1 segments (1 2 ... change_point(1)) ...
(change_point(K) ... N).
}
\examples{
a<-matrix(rnorm(40,mean=-1,sd=1),nrow=20,ncol=2)
b<-matrix(rnorm(120,mean=0,sd=1),nrow=60,ncol=2)
c<-matrix(rnorm(40,mean=1,sd=1),nrow=20,ncol=2)
x<-rbind(a,b,c)
ChangePoints(x,point_max=5)
ChangePoints(x,point_max=5,penalty="hq")
}
\references{
J. Ding, Y. Xiang, L. Shen, and V. Tarokh, \emph{Multiple Change
Point Analysis: Fast Implementation and Strong Consistency}. IEEE
Transactions on Signal Processing, vol. 65, no. 17, pp. 4495-4510, 2017.
}
