% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_trial_files.R
\name{write_trial_files}
\alias{write_trial_files}
\title{Write trial design files for field implementation}
\usage{
write_trial_files(td, folder_path, ext = "shp", zip = FALSE, zip_name = NA)
}
\arguments{
\item{td}{(tibble) a tibble of a trial design created by applying assign_rate() to experimental plots made by make_exp_plots().}

\item{folder_path}{(character) path to the folder in which the files will be saved}

\item{ext}{(character) Default = "shp". Extension to use to save the files, "geojson" or any other extension supported by sf::st_write()}

\item{zip}{(logical) Default = FALSE. If TRUE, all the files that are being written will be zipped.}

\item{zip_name}{(character) name of the zip file created when zip = TRUE.}
}
\value{
nothing
}
\description{
Write out all the necessary files to implement the trial design created. Exported files include
}
\examples{
#--- load trial design ---#
\donttest{
data(td_two_input)

write_trial_files(
  td = td_two_input,
  folder_path = tempdir(),
  zip = FALSE
)
}
}
