% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{recover_olc}
\alias{recover_olc}
\title{Recover Full Open Location Codes From Shortened Codes}
\usage{
recover_olc(olcs, lats, longs)
}
\arguments{
\item{olcs}{a vector of short open location codes, generated with \code{\link{shorten_olc}} or through
any other means.}

\item{lats}{a numeric vector of latitudes.}

\item{longs}{a numeric vector of longitudes, equivalent in size to \code{lats}.}
}
\description{
\code{\link{shorten_olc}} (and other sources) shorten a code, reducing
the space it occupies. They also limit its ability to be translated back into latitude/longitude
pairs. \code{recover_olc} recovers a full code from a shortened one, allowing it to be decoded with
\code{\link{decode_olc}}. \emph{Some} loss of accuracy or precision is expected - and as it finds
the closest match to the coordinates rather than to the original code, the characters may be very
different.
}
\examples{
# Shorten an OLC and then recover the nearest full code. Note the actual characters differ.
shortened_code <- shorten_olc("8FVC9G8F+6X", 47.5, 8.5);
recovered_code <- recover_olc(shortened_code, 47.4, 8.6);

}

