% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOLL-G.R
\name{GOLLG}
\alias{GOLLG}
\alias{pgollg}
\alias{dgollg}
\alias{qgollg}
\alias{rgollg}
\alias{hgollg}
\title{Generalized Odd log-logistic family of distributions (GOLL-G)}
\usage{
pgollg(x, alpha = 1, beta = 1, G = pnorm, ...)

dgollg(x, alpha = 1, beta = 1, G = pnorm, ...)

qgollg(q, alpha = 1, beta = 1, G = pnorm, ...)

rgollg(n, alpha = 1, beta = 1, G = pnorm, ...)

hgollg(x, alpha = 1, beta = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pgollg} gives the distribution function,
 \code{dgollg} gives the density,
 \code{qgollg} gives the quantile function,
 \code{hgollg} gives the hazard function and
 \code{rgollg} generates random variables from the Generalized Odd log-logistic family of
 distributions (GOLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Cordeiro et al. (2017) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,G^{\alpha\beta-1}[1-G^\alpha]^{\beta-1}}{[G^{\alpha\beta}+[1-G^\alpha]^\beta]^2}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{\beta > 0}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pgollg(x)
pgollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
dgollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dgollg, -3, 3)
qgollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rgollg(n, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
hgollg(x, alpha = 2, beta = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hgollg, -3, 3)
}
\references{
Cordeiro, G.M., Alizadeh, M., Ozel, G., Hosseini, B., Ortega, E.M.M., Altun, E. (2017). The generalized odd log-logistic family of distributions : properties, regression models and applications. Journal of Statistical Computation and Simulation ,87(5),908-932.
}
