% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oll-g.R
\name{OLLG}
\alias{OLLG}
\alias{pollg}
\alias{dollg}
\alias{qollg}
\alias{rollg}
\alias{hollg}
\title{Odd log-logistic family of distributions (OLL-G)}
\usage{
pollg(x, alpha = 1, G = pnorm, ...)

dollg(x, alpha = 1, G = pnorm, ...)

qollg(q, alpha = 1, G = pnorm, ...)

rollg(n, alpha = 1, G = pnorm, ...)

hollg(x, alpha = 1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{pollg} gives the distribution function,
 \code{dollg} gives the density,
 \code{qollg} gives the quantile function,
 \code{hollg} gives the hazard function and
 \code{rollg} generates random variables from the Odd log-logistic family of
 distributions (OLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Gleaton et al. (2006) specified by the pdf
\deqn{f=\frac{\alpha\,g\,G^{\alpha-1}\bar{G}^{\alpha-1}}{[G^\alpha+\bar{G}^\alpha]^2}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
pollg(x)
pollg(x, alpha = 2, G = pbeta, shape1 = 1, shape2 = 2)
dollg(x, alpha = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dollg, -3, 3)
qollg(x, alpha = 2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rollg(n, alpha = 2, G = pbeta, shape1 = 1, shape2 = 2)
hollg(x, alpha = 2, G = pbeta, shape1 = 1, shape2 = 2)
curve(hollg, -3, 3)
}
\references{
Gleaton, J. U., Lynch, J. D. (2006). Properties of generalized log-logistic families of lifetime distributions. Journal of Probability and Statistical Science, 4(1), 51-64.
}
