% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameCol.r
\name{renameCol}
\alias{renameCol}
\title{Rename columns}
\usage{
renameCol(x, old, new)
}
\arguments{
\item{x}{A \code{data.frame} or \code{matrix}.}

\item{old}{Character vector with names(s), or numeric vector of the indices of the column(s) you want to rename.}

\item{new}{Character vector of new names.}
}
\value{
A \code{data.frame} or \code{matrix}.
}
\description{
Rename columns of a \code{data.frame} or \code{matrix}.
}
\examples{

x <- data.frame(old_x = 1:5, old_y = letters[1:5], old_z = LETTERS[1:5])
x
renameCol(x, c('old_y', 'old_z'), c('new_Y', 'new_Z'))
renameCol(x, c(2, 3), c('new_Y', 'new_Z')) # same as above

# Long way:
new <- c('new_Y', 'new_Z')
colnames(x)[match(c('old_y', 'old_z'), colnames(x))] <- new

}
