% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ol_user_pwd_sha256_salt}
\alias{ol_user_pwd_sha256_salt}
\title{Set or changes user's password after encryption}
\usage{
ol_user_pwd_sha256_salt(con, user_id, password, password_confirmation,
  password_algorithm = "salt+sha256", password_salt = "")
}
\arguments{
\item{con}{a 'OneLogin' connection}

\item{user_id}{user id}

\item{password}{character, new password}

\item{password_confirmation}{character, new password}

\item{password_algorithm}{algorithm, defaults to "salt+sha256"}

\item{password_salt}{defaults to ""}
}
\description{
See the \href{https://developers.onelogin.com/api-docs/1/users/set-password-using-sha-256}{API docs} for details on how to encrypt the password.
}
\examples{
if (interactive()) ol_user_pwd_sha256_salt(onelogin(), 54963040,
safer::encrypt_string("saltpwd"), safer::encrypt_string("saltpwd"),
password_salt = "salt")
}
