% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepCalibration.r
\name{prepCalibration}
\alias{prepCalibration}
\title{Convert the assigned causes to the format expected by
vacalibration::vacalibration().}
\usage{
prepCalibration(fit, ...)
}
\arguments{
\item{fit}{a fitted object from \code{codeVA} using either InSilicoVA,
InterVA5, or output from \code{EAVA::codEAVA}.  The EAVA algorithm is assumed
if the the argument is a Data Frame (with columns "ID" and "cause").}

\item{...}{more fitted objects from \code{codeVA} using either InSilicoVA or
InterVA5, or from \code{EAVA::codEAVA}.}
}
\value{
a list with each element being a Data Frames that contains variables
"ID" and "cause", and the element's name (in the list) is the algorithm name
used to assign causes of death (either "insilicova", "interva", or "eava")
}
\description{
This function prepares the output from codeVA (using the InSilicoVA or
InterVA5 algorithms) and/or EAVA for the vacalibration function.  The 
output is a named list, with each element consisting of a data frame with
columns for the death ID ("ID") and the assigned CoD ("cause").  The name
of each element is the algorithm used to assign the CoD -- "insilicova",
"interva", or "eava".  If the
}
\examples{
\dontrun{
data(NeonatesVA5)
fit_insilico <- codeVA(NeonatesVA5)
insilico_prep <- prepCalibration(fit_insilico)
calib_insilico = vacalibration::vacalibration(va_data = insilico_prep,
                                              age_group = "neonate",
                                              country = "Mozambique")
summary(calib_insilico)

fit_interva <- codeVA(NeonatesVA5, model = "InterVA", version = "5", write = FALSE)
interva_prep <- prepCalibration(fit_interva)
calib_interva = vacalibration::vacalibration(va_data = interva_prep,
                                             age_group = "neonate",
                                             country = "Mozambique")
summary(calib_interva)

two_fits <- prepCalibration(fit_insilico, fit_interva)
calib_ensemble = vacalibration::vacalibration(va_data = two_fits,
                                              age_group = "neonate",
                                              country = "Mozambique")
summary(calib_ensemble)

} 
}
