% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notcore_utils.r
\name{summary.eava}
\alias{summary.eava}
\title{Summary of results obtained by fitting the EAVA algorithm.}
\usage{
\method{summary}{eava}(object, top = 5, rnd = 4, ...)
}
\arguments{
\item{object}{\code{eava} object}

\item{top}{number of top CSMF to show}

\item{rnd}{number of decimal places to round the CSMF}

\item{\dots}{not used}
}
\value{
\item{id}{ all IDs of the deaths}
\item{cause}{ assigned cause for individual of death }
\item{N}{ number of deaths}
\item{age_group}{age group that the deaths belong to (either child or neonate)}
\item{csmf.ordered}{ cause-specific mortality fractions in decreasing order }
}
\description{
This function prints a summary message of the results along with
the top cause-specific mortality fractions (CSMFs).
}
\examples{
\dontrun{
data(DataEAVA)
eava_results <- codeVA(DataEAVA, data.type = "EAVA", model = "EAVA")
eava_summary <- summary(eava_results)
eava_summary
} 
}
