% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_data.R
\name{get_user_data}
\alias{get_user_data}
\title{Get user data from OpenAppBuilder}
\usage{
get_user_data(
  site = get_app_connection(),
  filter = FALSE,
  filter_variable = NULL,
  filter_variable_value = NULL,
  date_from = NULL,
  date_to = NULL,
  format_date = "\%Y-\%m-\%d",
  tzone_date = "UTC"
)
}
\arguments{
\item{site}{The name of the PostgreSQL database connection (using \code{DBI::dbConnect} or \code{set_app_connection()}).}

\item{filter}{A logical value indicating whether to filter data (defaults to \code{FALSE}).}

\item{filter_variable}{A character string representing the name of the column to filter if \code{filter == TRUE} and \code{filter_variable_value} is provided.}

\item{filter_variable_value}{A character string representing the value of the \code{filter_variable} column to filter if \code{filter == TRUE}.}

\item{date_from}{An optional character string representing the date from which to retrieve data.}

\item{date_to}{An optional character string representing the date to which to retrieve data.}

\item{format_date}{A character string specifying the format of the date strings (defaults to "\%Y-\%m-\%d").}

\item{tzone_date}{A character string specifying the time zone for the date strings (defaults to "UTC").
System-specific (see \code{\link[base]{as.POSIXlt}}), but "" uses the current time zone, and "GMT" is UTC (Universal Time, Coordinated).
Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A data frame containing user data from the PostgreSQL database, with the \code{contact_fields} column parsed into separate columns.
}
\description{
Retrieves data from the \code{app_users} table in OpenAppBuilder, and efficiently converts the \code{contact_fields} column from JSON format to a data frame.
If \code{filter} is \code{TRUE}, the function further filters the data to include only rows where the specified \code{filter_variable} column matches \code{filter_variable_value}.
}
\examples{
# First we need to set an app connection
set_app_connection(
  dbname = "vmc",
  host = "apps-server.idems.international",
  port = 5432,
  user = "vmc",
  password = "LSQkyYg5KzL747"
)

# Retrieve all data from the 'app_users' table
data_all_users <- get_user_data()

# Retrieve data from the 'app_users' table where 'app_user_id' is
# a specified ID.
valid_ids <- c("3e68fcda-d4cd-400e-8b12-6ddfabced348",
               "223925c7-443a-411c-aa2a-a394f991dd52")
data_filtered_users <- get_user_data(
  filter = TRUE,
  filter_variable = "app_user_id",
  filter_variable_value = valid_ids
)

# Retrieve user data within a specific date range
date_filtered_data <- get_user_data(
  date_from = "2023-01-01",
  date_to = "2024-08-18"
)
}
