% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_latest_games.R
\name{get_latest_games}
\alias{get_latest_games}
\title{Obtain the latest parsed games, this is a good function to use if you're not picky on which
dates or MMR your data is, but want fast data. The latest games will always have parsed games
opposed to the general game list gotten from get_game_list(), wich only contains 5 - 10% parsed
games.}
\usage{
get_latest_games(num_games, min_duration = 1200, wait_time = 1,
  output = "all")
}
\arguments{
\item{num_games}{Min number of games you want to obtain (could get 1-10 more)}

\item{min_duration}{Do you want to exclude games below a certain duration threshold? We default
it to 1200seconds (20 minutes), as super short games often contain early abandons and griefers.}

\item{wait_time}{Wait time between API calls, default to 1.00 (which is what opendota wants you
to stay below, so don¨t change unless you have a good reason and talked to opendota about it).}

\item{output}{Defaulted to "all", which will extract entire JSON, if not all, it should have the
path to an R file that will be sourced and create some output, note the R file must also
output to output_list()}
}
\description{
Obtain the latest parsed games, this is a good function to use if you're not picky on which
dates or MMR your data is, but want fast data. The latest games will always have parsed games
opposed to the general game list gotten from get_game_list(), wich only contains 5 - 10% parsed
games.
}
\examples{
\dontrun{
parsed_games <- get_latest_games(100)
}
}
