% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{update_job}
\alias{update_job}
\title{Modifies a job with given parameter}
\usage{
update_job(
  id,
  title = NULL,
  description = NULL,
  process = NULL,
  plan = NULL,
  budget = NULL,
  additional = NULL,
  con = NULL,
  ...
)
}
\arguments{
\item{id}{the job id of a created job}

\item{title}{update title for the job}

\item{description}{update description}

\item{process}{A \code{\link[=Graph]{Graph()}}, a function returning a \code{\link[=ProcessNode]{ProcessNode()}} as an endpoint, the \code{\link[=ProcessNode]{ProcessNode()}}
will return the results or a self defined \code{\link[=Process]{Process()}}}

\item{plan}{replaces plan with the set value}

\item{budget}{replaces or sets the credits that can be spent at maximum}

\item{additional}{Additional, non-standardized job settings to send to the back-end}

\item{con}{connected and authenticated openEO client (optional) otherwise \code{\link[=active_connection]{active_connection()}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\description{
The function modifies a stores a job with a given parameter. The dot parameter contains all the values
that will be replaced or removed. The return shows a message of result or failure.
}
\details{
The '...' operator shall contain all the values that are to be replaced in the job. There are some reserved
keys.
The 'process_graph' option will replace the process graph with a newly defined one, therefore the process graph needs to be a Graph object.
The 'format' option will change the desired output format.
All other parameter will be assumed to be special output parameter. Remember, you don't need to specify a process graph or graph_id,
e.g. if you just want to update the output format.
To leave parameter unchanged, then don't mention it. If you want to delete some, then set them to NA.
}
