% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimCheck-package.R
\docType{package}
\name{optimCheck-package}
\alias{optimCheck}
\alias{optimCheck-package}
\title{Graphical and numerical checks for mode-finding routines.}
\description{
Tools for checking that the output of an optimization algorithm is indeed at a local mode of the objective function. This is accomplished graphically by calculating all one-dimensional "projection plots" of the objective function, i.e., varying each input variable one at a time with all other elements of the potential solution being fixed. The numerical values in these plots can be readily extracted for the purpose of automated and systematic unit-testing of optimization routines.
}
\examples{
# example: logistic regression
ilogit <- binomial()$linkinv

# generate data
p <- sample(2:10,1) # number of parameters
n <- sample(1000:2000,1) # number of observations
X <- matrix(rnorm(n*p),n,p) # design matrix
beta0 <- rnorm(p, sd = .1) # true parameter values
y <- rbinom(n, size = 1, prob = ilogit(X \%*\% beta0)) # response

# fit logistic regression
bhat <- coef(glm(y ~ X - 1, family = binomial))

# check convergence

# likelihood function
loglik <- function(beta, y, X) {
  sum(dbinom(y, size = 1, prob = ilogit(X \%*\% beta), log = TRUE))
}

# projection plots
bnames <- parse(text = paste0("beta[", 1:p, "]"))
system.time({
  oproj <- optim_proj(xsol = bhat,
                      fun = function(beta) loglik(beta, y, X),
                      xnames = bnames,
                      xlab = "Coefficient", ylab = "Loglikelihood")
})

# numerical summary
oproj # see ?summary.optproj for more information

# elementwise differences between potential and optimal solution
diff(oproj) # same as summary(oproj)$xdiff

# refit general purpose optimizer starting from bhat
# often faster than optim_proj, but less stable
system.time({
  orefit <- optim_refit(xsol = bhat,
                        fun = function(beta) loglik(beta, y, X))
})
orefit
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mlysy/optimCheck}
  \item Report bugs at \url{https://github.com/mlysy/optimCheck/issues}
}

}
\author{
\strong{Maintainer}: Martin Lysy \email{mlysy@uwaterloo.ca}

}
