% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFitUserDefinedDist.R
\docType{class}
\name{fitUserDefinedDist-class}
\alias{fitUserDefinedDist-class}
\alias{fitUserDefinedDist}
\title{An S4 class to fit a user-defined distribution on a vector of marker values.}
\description{
This class allows to fit a user-defined distribution on the marker values \code{x}.
}
\details{
This class is automatically created when the user applies the \code{fit} function with the argument \code{distr="user"}. You never have to create manually this class, it is created internally.
}
\section{Slots}{

\describe{
\item{\code{x}}{This slot takes in argument the marker values. Numeric argument.}

\item{\code{n}}{Length of x vector (including NA values). Numeric argument.}

\item{\code{paraNames}}{This slot is a character vector of distribution parameter names.}

\item{\code{mcmcList}}{This slot is an mcmc.list object summing up all the sampled parameters of the user-defined distribution.}

\item{\code{cdf}}{This slot is a function that describes the cumulative distribution function of the user-defined distribution.}

\item{\code{gradient}}{This slot is a function that describes the probability density function of the user-defined distribution.}

\item{\code{hessian}}{This slot is a function that describes the fisrt derivative of the probability density function of the user-defined distribution.}

\item{\code{mcmc}}{This slot allows the main function to k,now whether an MCMC algorithm must be performed to sample the distribution parameters from their posterior distribution.}
}}

\seealso{
\code{\link[optimalThreshold]{fit}} for more details on how to fit a user-defined distribution.
}
