% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nextdose.R
\name{nextdose}
\alias{nextdose}
\title{Estimates the updated model and next dose to be tested for the Proportional Odds Model (POM),
Continuation Ratio (CR) Model CRM, or binary 2-parameter logistic model CRM.}
\usage{
nextdose(design, pseudotox, pseudodose, collectedtox, collecteddose,
  cohortsize = 3, targetDLT = 0.3, pseudoweights = NA, discrete = FALSE,
  discretedoses = NA, rounddown = FALSE, numberdltrule = NA,
  lowerlimitrule = NA, upperlimitrule = NA, dltrule = NA,
  increaserule = NA, minimum = NA, maximum = NA, combine01 = FALSE,
  plotit = TRUE)
}
\arguments{
\item{design}{Specifies which dose finding design you are running simulations on.
Choices are: POM, CR, or CRM.}

\item{pseudotox}{A vector of toxicity grades specified by the pseudodata.}

\item{pseudodose}{A vector of dose levels specified by the pseudodata.}

\item{collectedtox}{A vector of treated patient toxicity outcomes.
For j patients treated up to this point in the trial, collecteddose is in the form:
c(toxicity grade patient 1, ..., toxicity grade patient j). \cr
If combine01 is false, toxicity grades range from 0, 1, 2, 3, and 4.
If combine01 is true, toxicity grades are coded 0 (grades 0 and 1), 1 (grade 2), 2 (grade 3),
and 3 (grade 4). Toxicity grades are specified according to CTCAEv4.0.}

\item{collecteddose}{A vector of treated patient dose levels. For j patients treated up to this point
in the trial, collecteddose is in the form: c(dose patient 1, ..., dose patient j).}

\item{cohortsize}{Number of patients treated in a cohort. Defaults to 3.}

\item{targetDLT}{Target dose limiting toxicity (DLT) rate pre-specified by clinical investigators prior to the start of the trial.
Must be specified between 0 and 1. Defaults to 0.30.}

\item{pseudoweights}{Pseudoweights determine the amount of influence the pseudodata has on estimating the updated model.
Please refer to Van Meter et al (2010) for more information. We suggest setting the pseudoweights equal to the cohortsize.
When pseudoweights = X, the total pseudodata represent X individuals in the updated model. If not specified,
pseudoweights defaults to cohortsize.
Must be specified between 0 and 1. Defaults to 0.30.}

\item{discrete}{True/False. If discrete = TRUE this allows for discrete dose levels
to be specified prior to the start of the trial. Defaults to FALSE.}

\item{discretedoses}{Specified discrete dose levels if desired. They must be specified if discrete is equal to TRUE.
It is written for j dose levels as: c(d1, d2,..., dj).}

\item{rounddown}{True/False. Only applicable when using discrete dose levels.\cr
If rounddown = TRUE, the estimate dose from specified model will round down to the more conservative discrete dose level.\cr
If rounddown = FALSE, it will select the discrete dose closest to the estimated model selection. Defaults to FALSE.}

\item{numberdltrule}{Number of dose limiting toxicities (DLTs) that would be considered excessively unsafe if observed in a cohort of patients.
This would prompt the DLT constraint if there is one specified. Defaults to NA.}

\item{lowerlimitrule}{If lowerlimitrule is specified, this constraint will stop the trial if the dose
is estimated to be under a certain level as a safety precaution. Investigators may feel any dose under
this lowerlimitrule would suggest excessive toxicity with this investigational drug and no true MTD may exist.\cr
This can be specified as a dose level or percentage.\cr
If lowerlimitrule <1 (percentage), it takes the range of possible data (maximum - minimum) and makes the lower bound
when the trial would stop early as: minimum + (maximum - minimum)*lowerlimitrule.\cr
If lowerlimitrule >1 (dose level) then the lower bound when the trial would stop early is the lowerlimitrule.}

\item{upperlimitrule}{If upperlimitrule is specified, this constraint will stop the trial if the dose is estimated to be higher
than a certain level. \cr
If upperlimitrule <1 (percentage), it takes the range of possible data (maximum - minimum) and makes the upper bound
when the trial would stop early as: maximum - (maximum - minimum)*upperlimitrule. \cr
If upperlimitrule >1 (dose level) then the upper bound
when the trial would stop early is the upperlimitrule.}

\item{dltrule}{If the numberdltrule (i.e. 2 DLTs) occurs in the last cohort of patients tested,
the next estimated dose must decrease by an amount specified by the dltrule.
Defaults to NA.  \cr
If 0 < dltrule < 1 (percentage), with excessive DLTs in the last cohort,
the next estimated dose must decrease by the dltrule (percentage) of
the last tested dose level, i.e. (1-dltrule)*lastdose.\cr
If dltrule >= 1 (dose level), with excessive DLTs in the last cohort
the next estimated dose must decrease by dltrule dose level, i.e. lastdose-dltrule.}

\item{increaserule}{If increaserule is specified, then the next estimated dose
can only increase by an amount specified by the increaserule between tested cohorts. Defaults to NA.\cr
If 0 < increaserule < 1 (percentage), the next dose can only increase to a maximum of lastdose*(1+increaserule).\cr
If increaserule >= 1 (dose level), the next dose can only increase to a maximum of lastdose + increaserule.}

\item{minimum}{Minimum dose that will be considered to test patients. Must be specified if lowerlimitrule<1.}

\item{maximum}{Maximum dose that will be considered to test patients. Must be specified if upperlimitrule<1.}

\item{combine01}{True/False. If combine01 = TRUE, toxicity grades 0 and 1 are combined into 1 category.
Therefore all toxicities must be coded: 0 (grades 0 and 1), 1 (grade2), 2 (grade 3),
and 3 (grade 4) according to CTCAEv4.0. Defaults to FALSE.}

\item{plotit}{True/False. If true, returns a plot of the updated model with the next dose to test in a cohort identified
as well as the current accrued patient toxicity outcomes. Defaults to TRUE.}
}
\value{
\item{Next Dose with No Used Constraints}{Returns estimated dose with no safety constraints
implemented for a specified target DLT rate.}

\item{Next Dose with Constraints if Applicable}{Returns estimated dose with safety constraints used if
applicable for a specified target DLT rate.}

\item{Next Dose if Using Discrete Dose Levels}{Returns the next dose estimated if
discrete dose levels are requested.}

\item{Estimated Probability of a Grade 0 or 1 Toxicity}{Using the newly re-estimated model
based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 0 or 1 toxicity as specified by CTCAEv4.0.
Only applicable if combine01 = TRUE.}

\item{Estimated Probability of a Grade 0 Toxicity}{Using the newly re-estimated model based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 0 toxicity as specified by CTCAEv4.0.
Only applicable if combine01 = FALSE.}

\item{Estimated Probability of a Grade 1 Toxicity}{Using the newly re-estimated model based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 1 toxicity as specified by CTCAEv4.0.
Only applicable if combine01 = FALSE.}

\item{Estimated Probability of a Grade 2 Toxicity}{Using the newly re-estimated model based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 2 toxicity as specified by CTCAEv4.0.}

\item{Estimated Probability of a Grade 3 Toxicity}{Using the newly re-estimated model based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 3 toxicity as specified by CTCAEv4.0.}

\item{Estimated Probability of a Grade 4 Toxicity}{Using the newly re-estimated model based on the combination of pseudodata and updated patient information,
this returns the probability of experiencing a grade 4 toxicity as specified by CTCAEv4.0.}

\item{Estimated Regression Model}{Returns parameter estimates for the newly re-estimated model based on the combination of pseudodata and updated patient information.}

\item{Influence from Pseudodata}{Returns the percentage of influence the pseudodata has on estimating the new model.
Please refer to Van Meter et al (2010) for more information.}

\item{Influence from Collected Data}{Returns the percentage of influence the treated patient data has on estimating the new model.
Please refer to Van Meter et al (2010) for more information.}

\item{Constraints Used}{Identifies which safety constraint was implemented if any. Returns: DLT Rule Used, Increase Rule Used,
 Lower Bound Stop Rule Used, Upper Bound Stop Rule Used, or None Used.}
}
\description{
This function incorporates pseudodata created in \code{\link{pseudodata}} with the collected cohorts
of patient information and updates the fitted model selected (choice of POM, CR, or binary 2-parameter
logistic model). Using this newly updated model, it then re-estimates the next dose to be tested for
a specified target dose limiting toxicity (DLT) rate. It has the flexibility to add in various
safety constraints and can accommodate continuous or discrete doses. This function also has to option to
combine toxicity grades 0 and 1 as specified by CTCAEv4.0 into one category should clinical investigators
wish to do so.
}
\details{
If using a POM CRM, this function assumes a proportional odds model as described by Harrell (Harrell, 2001).
For combine01=FALSE, y equal to toxicity grade outcomes j in c(0, 1, 2, 3, 4) as specified by CTCAEv4.0, and x equal to the dose,
this is written in the form:\cr
\deqn{P(y>=j|x)=1/(1+exp(-(\alpha_j + \beta*x))),for j = 1, 2, 3, 4}\cr
For combine01=Ture, toxicity grades are now 0/1, 2, 3, and 4, and y is recoded as 0 = grades 0 and 1, 1 = grade 2,
2 = grade 3, and 3 = grade 4.\cr

If using a CR model design, this function assumes a continuation ratio model as described by Harrell (Harrell, 2001).
For combine01=FALSE, y equal to toxicity grade outcomes j in c(0, 1, 2, 3, 4) as specified by CTCAEv4.0, and x equal to the dose,
this is written in the form:\cr
\deqn{P(y=j|y>=j,x)=1/(1+exp(-(\alpha + \theta_j + \gamma*x))), j = 0, 1, 2, 3}\cr
For combine01=TURE, toxicity grades are now 0/1, 2, 3, and 4, and y is recoded as 0 = grades 0 and 1, 1 = grade 2,
2 = grade 3, and 3 = grade 4.\cr

If using a binary CRM, this assumes a standard 2-parameter logistic model.
For y equal to toxicity outcome (1 is a DLT, 0 is not a DLT) and x equal to the dose, it is written in the form:\cr
\deqn{P(y=1|x)=1/(1+exp(-(\alpha + \beta*x)))}\cr

Estimated next dose is calculated by Pr(3 or 4 toxicity) <= targetDLT for the model utilized.
}
\examples{
#Pseudodata toxicity grades#
initial.cr.y1 <- c(rep(0, 45), rep(1, 36), rep(2, 9), rep(3, 8), rep(4, 2),
                   rep(0, 24), rep(1, 31), rep(2, 15), rep(3, 26), rep(4, 4),
                   rep(0, 14), rep(1, 23), rep(2, 13), rep(3, 40), rep(4, 10),
                   rep(0, 1), rep(1, 4), rep(2, 5), rep(3, 35), rep(4, 55))

#Pseudodata dose levels#
initial.cr.d1 <- c(rep(200, 100), rep(934, 100), rep(1467, 100), rep(3000, 100))

#Pseudodata toxicity grades if combining grades 0 and 1 into 1 category#
combine.cr.y1 <- c(rep(0, 81), rep(1, 9), rep(2, 8), rep(3, 2),
                   rep(0, 55), rep(1, 15), rep(2, 26), rep(3, 4),
                   rep(0, 37), rep(1, 13), rep(2, 40), rep(3, 10),
                   rep(0, 5), rep(1, 5), rep(2, 35), rep(3, 55))

#6 patients already treated at doses 1060 and 800 respectively
#CR model assumption

#Example 1
nextdose(design='CR', pseudotox = initial.cr.y1, pseudodose = initial.cr.d1, cohortsize =,
         collectedtox = c(1, 4, 2, 0, 0, 1), collecteddose = c(1060, 1060, 1060, 800, 800, 800),
         targetDLT = 0.30, pseudoweights = 3, discrete = FALSE, discretedoses = NA,
         combine01 = FALSE, lowerlimitrule = 500)

#Example 2
#Discrete doses and combining grades 0 and 1
nextdose(design='CR', pseudotox = combine.cr.y1, pseudodose = initial.cr.d1, cohortsize =,
        collectedtox = c(1, 3, 2, 0, 0, 1), collecteddose = c(1060, 1060, 1060, 800, 800, 800),
        targetDLT = 0.30, pseudoweights = 3, discrete = TRUE,
        discretedoses = c(200, 500, 100, 1200, 1500, 1800), combine01 = TRUE,
        lowerlimitrule = 500)
}
\author{
Emily V. Dressler, PhD \cr
Markey Cancer Center\cr
Division of Cancer Biostatistics\cr
University of Kentucky\cr
\email{EmilyVDressler@gmail.com}
}
\references{
1. Van Meter EM, Garrett-Mayer E, Bandyopadhyay D. Proportional odds model for dose finding clinical trial designs with ordinal toxicity grading. Statistics in Medicine 2011; 30: 2070-2080. \cr
2. Van Meter EM, Garrett-Mayer E, Bandyopadhyay. Dose finding clinical trial design for ordinal toxicity grades using the continuation ratio model: an extension of the continual reassessment method. Clinical Trials 2012; 9(3): 303-313. \cr
3. Garrett-Mayer E. The continual reassessment method for dose-finding studies: a tutorial. Clinical Trials 2006; 3: 57-71. \cr
4. Piantadosi S, Fisher JD, Grossman S. Practical implementation of a modified continual reassessment method for dose-finding trials. Cancer Chemother Pharmacol 1998; 41: 429-436. \cr
5. Harrell FE, Jr. Regression Modeling Strategies with Application to Linear Models, Logistic Regression, and Survival Analysis. Springer: New York, NY, 2001. \cr
6. McCullagh P. Regression Models for Ordinal Data. Journal of the Royal Statistical Society. Series B (Methodological). 1980; 42: 109-142. \cr
7. CTCAE. Cancer Therapy Evaluation Program, Common Terminology Criteria for Adverse Events, Version 4.0, DCTD, NCI, NIH, DHHS (http://ctep/cancer.gov). In Cancer Therapy Evaluation Program, 2010.
}
\seealso{
\code{\link{pseudodata}}
}

