% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_gammag1.R
\name{order_gammag1}
\alias{order_gammag1}
\title{Random Sampling of k-th Order Statistics from a Gamma G I Distribution}
\usage{
order_gammag1(size, spec, a, k, n, p = 0.5, alpha = 0.05, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific G distribution. Possible values "norm", "exp","lnorm","chisq".}

\item{a}{numeric, represents the first shape parameter. Default value is 1.}

\item{k}{numeric, represents the K-th smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{p}{numeric, represents the 100p percentile for the distribution of the K-th order statistic. Default value is population median, p = 0.5.}

\item{alpha}{numeric, (1 - alpha) represents the confidence of an interval for the population median of the distribution of the k-th order statistic. Default value is 0.05.}

\item{...}{represents others parameters of the G distribution.}
}
\value{
A list with a random sample of order statistics from a Gamma G I Distribution, the value of its join probability density function evaluated in the random sample and
and an approximate (1 - alpha) confidence interval for the population percentile p of the distribution of the k-th order statistic.
}
\description{
\code{order_gammag1} is used to obtain a random sample of the k-th order statistic from a Gamma G I distribution and some associated quantities of interest.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Gamma Exponential I Distribution
order_gammag1(10,"exp",1,k=3,n=50,p=0.5,alpha=0.02)
# A sample of size 10 of the 3-th order statistics from a Gamma Normal I Distribution
order_gammag1(10,"norm",1,k=3,n=50,p=0.5)
# A sample of size 10 of the 3-th order statistics from a Gamma Log-normal I Distribution
order_gammag1(10,"lnorm",1,k=3,n=50,p=0.5)
# A sample of size 10 of the 3-th order statistics from a Gamma Chi-square I Distribution
order_gammag1(10,"chisq",1,k=3,n=50,p=0.5,df=3)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
