% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordregr_lpost.R
\name{ordregr_lpost}
\alias{ordregr_lpost}
\title{Log-posterior function for a proportional odds model}
\usage{
ordregr_lpost(
  y,
  nc,
  Xcal,
  theta,
  descending = FALSE,
  prior = list(mean = NULL, Prec = NULL),
  gradient = TRUE,
  Hessian = TRUE
)
}
\arguments{
\item{y}{Vector containing the ordinal response (coded using integers in 1:nc).}

\item{nc}{(optional) Maximum value of \code{y}.}

\item{Xcal}{Design matrix.}

\item{theta}{Vector c(alpha,beta) with intercepts <alpha> and regression parameters <beta>.}

\item{descending}{Logical indicating if the odds of the response taking a value in the upper scale should be preferred over values in the lower scale.}

\item{prior}{(optional) List given the mean and Prec(ision) of the regression parameters.}

\item{gradient}{Logical indicating if the gradient of the log-posterior should be computed.}

\item{Hessian}{Logical indicating if the Hessian of the log-posterior should be computed.}
}
\value{
The log-posterior with the following attributes:
\itemize{
\item{\code{Salpha} : \verb{ }}{gradient wrt intercepts 'alpha'.}
\item{\code{Sbeta} : \verb{ }}{gradient wrt regression parameters 'beta'.}
\item{\code{grad} : \verb{ }}{gradient wrt  c(alpha,beta).}
\item{\code{Halpha} : \verb{ }}{Hessian wrt intercepts 'alpha'.}
\item{\code{Hbeta} : \verb{ }}{Hessian wrt regression parameters 'beta'.}
\item{\code{Hba} : \verb{ }}{cross-derivatives (Hessian) submatrix wrt 'alpha' & 'beta'.}
\item{\code{Hessian} : \verb{ }}{Hessian wrt c(alpha,beta).}
\item{\code{dtheta} : \verb{ }}{step in a Newton-Raphson iteration: solve(-Hessian,grad).}
}
}
\description{
Log-posterior function for a proportional odds model
}
\references{
Lambert, P. and Gressani, 0. (2023) Penalty parameter selection and asymmetry corrections
to Laplace approximations in Bayesian P-splines models. Statistical Modelling. <doi:10.1177/1471082X231181173>. Preprint: <arXiv:2210.01668>.
}
