#' Generates counts from table frequencies for 3 category items
#'
#' @param mij Matrix of counts.
#' @returns a list containing
#'    wm1m1:  for -1, -1
#'    wm10:   for -1, 0
#'    wm11:   for -1, 1
#'    w00:    for 0, 0
#'    w01:    for 0, 1
#'    w11:    for 1, 1
Cliff_counts_3 <- function(mij) {

  wm1m1 <- (mij[2,1]^2 + mij[3,1]^2 + mij[3,2]^2 + 2 * mij[2,2] * mij[3,1]
            + 2 * mij[2,1] *mij[3,1] + 2 * mij[3,1] * mij[3,2])

  wm10 <- (mij[1,1] * mij[2,1] + mij[1,1] * mij[3,1] + mij[1,2] * mij[3,1] + mij[2,1] * mij[1,1]
           + mij[2,1] * mij[2,2] + mij[2,1] * mij[3,2] + mij[2,2] * mij[2,1] + mij[2,2] * mij[3,2]
           + mij[2,3] * mij[3,1] + mij[3,1] * mij[1,1] + mij[3,1] * mij[1,2] + mij[3,1] * mij[2,3]
           + mij[3,1] * mij[3,3] + mij[3,2] * mij[2,1] + mij[3,2] * mij[2,2] + mij[3,2] * mij[3,3]
           + mij[3,3] * mij[3,1] + mij[3,3] * mij[3,2] )

  wm11 <- (mij[1,1] * mij[2,2] + mij[1,1] * mij[2,3] + mij[1,1] * mij[3,2] + mij[1,1] * mij[3,3]
           + mij[1,2] * mij[3,2] + mij[1,2] * mij[3,3] + mij[2,1] * mij[2,3] + mij[2,1] * mij[3,3]
           + mij[2,2] * mij[1,1] + mij[2,2] * mij[3,3] + mij[2,3] * mij[1,1] + mij[2,3] * mij[2,1]
           + mij[3,2] * mij[1,1] + mij[3,2] * mij[1,2] + mij[3,3] * mij[1,1] + mij[3,3] * mij[1,2]
           + mij[3,3] * mij[2,1] + mij[3,3] * mij[2,2] )

  w00 <- (mij[1,1]^2 + mij[2,2]^2 + mij[3,3]^2 + 2 * mij[1,2] * mij[2,1]
          + 2 * mij[1,3] * mij[3,1] + 2 * mij[2,3] * mij[3,2])

  w01 <- (mij[1,1] * mij[1,2] + mij[1,1] * mij[1,3] + mij[1,2] * mij[1,1] + mij[1,2] * mij[2,2]
          + mij[1,2] * mij[2,3] + mij[1,3] * mij[1,1] + mij[1,3] * mij[2,1] + mij[1,3] * mij[3,2]
          + mij[1,3] * mij[3,3] + mij[2,1] * mij[1,3] + mij[2,2] * mij[1,2] + mij[2,2] * mij[2,3]
          + mij[2,3] * mij[1,2] + mij[2,3] * mij[2,2] + mij[2,3] * mij[3,3] + mij[3,2] * mij[1,3]
          + mij[3,3] * mij[1,3] + mij[3,3] * mij[2,3] )

  w11 <- (mij[1,2]^2 + 2 * mij[1,2] * mij[1,3] + mij[1,3]^2 + 2 * mij[1,3] * mij[2,2]
          + 2 * mij[1,3] * mij[2,3] + mij[2,3]^2)

  result <- list("wm1m1" = wm1m1, "wm10" = wm10, "wm11" = wm11,
                 "w00" = w00, w01 = w01, "w11" = w11)
  result
}
