% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_linear.R
\name{log_linear_fit}
\alias{log_linear_fit}
\title{Fits a log-linear model to the data provided, using the design matrix provided.
Names for the effects will be "rows1", "cols1" etc.  If there are remaining entries,
they can be specified as the "effect_names" character vector.
This function is a wrapper around a call to glm() that handles some of the details
of the call and packages the output in a more convenient form.}
\usage{
log_linear_fit(n, x, effect_names = NULL)
}
\arguments{
\item{n}{matrix of observed counts to be fit}

\item{x}{design matrix for predictor variables}

\item{effect_names}{character vector of additional names to apply to the columns of x
The default is NULL, in which case the columns will be labeled "model1" etc.}
}
\value{
a list containing
   x: the design matrix
   beta: the regression parameters
   se: the vector of standard errors
   g_squared: G^2 fit measure
   chisq: X^2 fit measure
   df: degrees of freedom
   expected: matrix of expected frequencies
}
\description{
Fits a log-linear model to the data provided, using the design matrix provided.
Names for the effects will be "rows1", "cols1" etc.  If there are remaining entries,
they can be specified as the "effect_names" character vector.
This function is a wrapper around a call to glm() that handles some of the details
of the call and packages the output in a more convenient form.
}
