#' Tests based on examples in Chapter 11 of Agresti, A. (1984). Analysis of ordinal
#' categorical data. New York: Wiley.


test_that("symmetry is correct", {
  result <- Bowker_symmetry(occupational_status)
  expect_true(abs(37.5 - result$g_squared) <= 0.5, info=paste(37.5, result$g_squared))
  expect_true(abs(37.5 - result$chisq) <= 0.5, info=paste(37.5, result$chisq))
  expect_equal(10, result$df)
}
)


test_that("conditional symmetry is correct", {
  result <- McCullagh_conditional_symmetry(occupational_status)
  expect_true(abs(result$g_squared - 10.4) <= 0.06, info=paste(10.4, result$g_squared))
  expect_equal(result$df, 9)
}
)


test_that("diagonals parameter symmetry is correct", {
  suppressWarnings( {
    result <- Goodman_diagonals_parameter_symmetry(occupational_status)
    expect_true(abs(6.4 - result$omnibus_chisq) <= 0.05)
    expect_equal(6, result$omnibus_df)
    delta <- result$delta
    expect_true(abs(1.31 - 1.0 / delta[1]) <= 0.005, info=paste(1.31, delta[1]))
    expect_true(abs(1.11 - 1.0 / delta[2]) <= 0.005, info=paste(1.11, delta[2]))
    expect_true(abs(1.30 - 1.0 / delta[3]) <= 0.005, info=paste(1.30, delta[3]))
    expect_true(abs(2.67 - 1.0 / delta[4]) <= 0.005, info=paste(2.67, delta[4]))

    expect_true(abs(6.4 - result$omnibus_chisq) <= 0.05, info=paste(6.4, result$omnibus_chisq))
    expect_equal(result$omnibus_df, 6)
    # Agresti (1984) gives this as 4 for difference in G^2, Difference in Pearson X^2 is 3.85
    expect_true(abs(result$equality_chisq - 3.85) <= 0.005, info=paste(3.85, result$equality_chisq))
    expect_equal(result$equality_df, 3)
    # Agresti (1984) gives this as 1.26.  I get 1.31
    expect_true(abs(1.0 / result$delta[1] - 1.26) <= 0.05)
  })
}
)


test_that("marginal homogenity works", {
  result <- Bhapkar_marginal_homogeneity(occupational_status)
  expect_true(abs(result$chisq - 32.9) <= 0.05)
  expect_equal(result$df, 4)
}
)


test_that("man-whitney tau is correct", {
  result <- Agresti_weighted_tau(occupational_status)
  expect_true(abs(result$tau - 0.0507) <= 0.00005)
  expect_true(abs(result$sigma_tau - 0.0102) <= 0.00005)
}
)

test_that("homicide symmetry tests are correct", {
  result1 <- Bowker_symmetry(homicide_black_white)
  expect_true(abs(result1$g_squared - 1.98) < 0.005)
  expect_equal(result1$df, 3)

  result2 <- Bowker_symmetry(homicide_white_white)
  expect_true(abs(result2$g_squared - 13.59) < 0.005)
  expect_equal(result2$df, 3)

  result3 <- Bowker_symmetry(homicide_black_black)
  expect_true(abs(result3$g_squared - 3.02) < 0.005)
  expect_equal(result3$df, 3)

  result4 <- Bowker_symmetry(homicide_white_black)
  expect_true(abs(result4$g_squared - 6.74) < 0.005)
  expect_equal(result4$df, 3)
})
