% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_user.R
\name{summary.orf.prediction}
\alias{summary.orf.prediction}
\title{Summary of the Ordered Forest Prediction}
\usage{
\method{summary}{orf.prediction}(object, latex = FALSE, ...)
}
\arguments{
\item{object}{predicted Ordered Forest object of class \code{orf.prediction}}

\item{latex}{logical, if TRUE latex coded summary will be generated (default is FALSE)}

\item{...}{further arguments (currently ignored)}
}
\description{
summary of Ordered Forest predictions of class \code{orf.prediction}
}
\details{
\code{summary.orf.prediction} provides a main summary of the Ordered Forest
prediction, including the input information regarding the values of hyperparameters
as well as the inputs of the \code{predict.orf} function.
}
\examples{
# Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates for train and test
idx <- sample(seq(1, nrow(odata), 1), 0.8*nrow(odata))

# train set
Y_train <- as.numeric(odata[idx, 1])
X_train <- as.matrix(odata[idx, -1])

# test set
Y_test <- as.numeric(odata[-idx, 1])
X_test <- as.matrix(odata[-idx, -1])

# estimate Ordered Forest
orf_fit <- orf(X_train, Y_train)

# predict the probabilities with the estimated orf
orf_pred <- predict(orf_fit, newdata = X_test)

# summary of the prediction object
summary(orf_pred)

# show summary of the orf prediction coded in LaTeX
summary(orf_pred, latex = TRUE)

}
\author{
Gabriel Okasa
}
