% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{nextHeader}
\alias{nextHeader}
\title{Check String Against DICOM Header Field to Produce Error Message or NEXT}
\usage{
nextHeader(dcm, string, reference, str.warning, htmlfile = NULL,
  heading = 3, numeric = FALSE)
}
\arguments{
\item{dcm}{is the DICOM list structure.}

\item{string}{is a character string to be matched with the DICOM header.}

\item{reference}{is the scalar/vector of character strings to check against
the DICOM header output.}

\item{str.warning}{is a text string for the warning.}

\item{htmlfile}{is the \pkg{hwriter} object for the HTML file (default =
\code{NULL}.}

\item{heading}{is the HTML tag <H?> (default = \code{3}).}

\item{numeric}{is the argument to be passed to \code{matchHeader}.}
}
\value{
An expression to be evaluated and HTML content.
}
\description{
A function designed to \code{break} out of loops given information (or the
lack thereof) contained in the DICOM header.
}
\references{
Digital Imaging and Communications in Medicine (DICOM)\cr
\url{http://medical.nema.org}
}
\seealso{
\code{\link{extractHeader}}, \code{\link{matchHeader}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
