% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{surv_forward_solver}
\alias{surv_forward_solver}
\title{surv_forward_solver \code{C++} function}
\usage{
surv_forward_solver(
  B,
  X,
  Fail_Ind,
  bw,
  rho,
  eta,
  gamma,
  tau,
  epsilon,
  btol,
  ftol,
  gtol,
  maxitr,
  verbose,
  ncore
)
}
\arguments{
\item{B}{A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint}

\item{X}{The covariate matrix (This matrix is ordered by the order of Y for faster computation)}

\item{Fail_Ind}{The locations of the failure subjects}

\item{bw}{Kernel bandwidth for X}

\item{rho}{(don't change) Parameter for control the linear approximation in line search}

\item{eta}{(don't change) Factor for decreasing the step size in the backtracking line search}

\item{gamma}{(don't change) Parameter for updating C by Zhang and Hager (2004)}

\item{tau}{(don't change) Step size for updating}

\item{epsilon}{(don't change) Parameter for approximating numerical gradient}

\item{btol}{(don't change) The \code{$B$} parameter tolerance level}

\item{ftol}{(don't change) Estimation equation 2-norm tolerance level}

\item{gtol}{(don't change) Gradient tolerance level}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}

\item{ncore}{The number of cores for parallel computing}
}
\value{
The optimizer \code{B} for the esitmating equation.
}
\description{
The main optimization function for survival dimensional reduction, the forward method. This is an internal function and should not be called directly.
}
\examples{
# This function should be called internally. When having all objects pre-computed, one can call
# surv_forward_solver(B, X, Fail.Ind, bw,
#                     rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
# to solve for the parameters B.

}
\references{
Sun, Q., Zhu, R., Wang, T., & Zeng, D. (2019). Counting process-based dimension reduction methods for censored outcomes.
Biometrika, 106(1), 181-196.
DOI: \doi{10.1093/biomet/asy064}
}
\keyword{internal}
