% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traversal.R
\name{bng_kring}
\alias{bng_kring}
\alias{bng_kdisc}
\title{Spatial neighbourhoods in the British National Grid index system}
\usage{
bng_kring(bng_ref, k, ...)

bng_kdisc(bng_ref, k, ...)
}
\arguments{
\item{bng_ref}{an object of type \code{BNGReference}}

\item{k}{numeric value measuring the number of grid squares traversed between
the ring and input BNG reference}

\item{...}{additional parameters. Not currently used}
}
\value{
list containing an unordered collection of objects of type
\code{BNGReference} within the neighbourhood around the given grid
reference.
}
\description{
Identify neighbours in a hollow ring or solid disc at grid distance 'k' from
a target BNG reference.
}
\details{
K-rings are hollow rings of grid squares at a grid distance \code{k}
while k-discs are filled areas around a given grid square up to a grid
distance k. \code{bng_kdisc} includes the given BNG Reference (i.e. the
central grid square).

In the event that \code{bng_ref} is along the edge or corner of the valid
BNG area, then any return BNG references of the ring/disc outside the valid
BNG range will not be returned.
}
\examples{
bng_kring(as_bng_reference("SU1234"), 1)

bng_kring(as_bng_reference("SU1234"), 3)

bng_kdisc(as_bng_reference("SU1234"), 1)

bng_kdisc(as_bng_reference("SU1234"), 3)

}
