% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprotLiteratureQuery.R
\name{uniprotLiteratureQuery}
\alias{uniprotLiteratureQuery}
\title{Retrieve UniProt Literature data for a specified gene and disease.}
\usage{
uniprotLiteratureQuery(ensemblId, efoId, size = 3500)
}
\arguments{
\item{ensemblId}{Character: ENSEMBL ID of the target gene (e.g., "ENSG00000130203").}

\item{efoId}{Character: EFO ID of the target disease (e.g., "MONDO_0004975").}

\item{size}{Integer: Number of records to retrieve (default: 3500).}
}
\value{
Returns a tibble containing UniProt literature evidence data for the specified gene and disease.
}
\description{
This function queries the Open Targets GraphQL API to retrieve UniProt literature evidence data
for a specified gene and disease.
}
\examples{
\dontrun{
result <- uniprotLiteratureQuery(ensemblId = "ENSG00000130203", efoId = 
"MONDO_0004975", size = 3500)
}
}
