% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_probabilities.R
\encoding{UTF-8}
\name{joint_probabilities}
\alias{joint_probabilities}
\title{Computes the joint probabilities of an ordinal time series}
\usage{
joint_probabilities(series, lag = 1, states)
}
\arguments{
\item{series}{An OTS.}

\item{lag}{The considered lag (default is 1).}

\item{states}{A numerical vector containing the corresponding
states.}
}
\value{
A matrix with the joint probabilities.
}
\description{
\code{joint_probabilities} returns a matrix with the joint
probabilities of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
matrix \eqn{\widehat{\boldsymbol P}(l) = \big(\widehat{p}_{i-1j-1}(l)\big)_{1 \le i, j \le n+1}},
with \eqn{\widehat{p}_{ij}(l)=\frac{N_{ij}(l)}{T-l}}, where \eqn{N_{ij}(l)} is the number
of pairs \eqn{(\overline{X}_t, \overline{X}_{t-l})=(s_i,s_j)} in the realization \eqn{\overline{X}_t}.
}
\examples{
matrix_jp <- joint_probabilities(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the matrix of
# joint probabilities for one series in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
