% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib_diff.R
\name{distrib_diff_lcwm_g}
\alias{distrib_diff_lcwm_g}
\title{Compute the dissimilarity for a single component of a Linear CWM.}
\usage{
distrib_diff_lcwm_g(x, z_g, mu_g, sigma_g, mod_g, y_sigma_g, dd_weight = 0.5)
}
\arguments{
\item{x}{Covariate data only.}

\item{z_g}{Component assignment probability vector.}

\item{mu_g}{Component mean vector for the covariates.}

\item{sigma_g}{Component covariance matrix for the covariates.}

\item{mod_g}{Component regression model.}

\item{y_sigma_g}{Component regression standard deviation for the response.}

\item{dd_weight}{A value between \code{0} and \code{1} which controls the weighting of
the response and covariate dissimilarities when aggregating.}
}
\value{
\code{distrib_diff_lcwm_lcwm_g} returns a list with the following elements:
\describe{
\item{\code{diff}}{Aggregated dissimilarity value for this component.}
\item{\code{dens}}{Joint (covariate & response) density of all observations for
this component.}
\item{\code{diff_x}}{Covariate dissimilarity value for this component.}
\item{\code{diff_y}}{Response dissimilarity value for this component.}
\item{\code{dens_x}}{Covariate density of all observations for this component.}
\item{\code{dens_y}}{Response density of all observations for this component.}
}
}
\description{
Computes the covariate dissimilarity value, the response dissimilarity value,
and their aggregated dissimilarity value. It also obtains the covariate,
response, and joint densities for every observation.
}
