% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinner_outlier_score.R
\name{spinner_outlier_score}
\alias{spinner_outlier_score}
\title{Spinner-Based Geometric Multivariate Outlier Detection}
\usage{
spinner_outlier_score(
  X,
  n_spins = 1000,
  robust = TRUE,
  cov_adjust = TRUE,
  contrib_quantile = 0.9,
  plot_top_n = NULL,
  make_contrib_plot = FALSE,
  seed = NULL
)
}
\arguments{
\item{X}{A numeric matrix or data frame of dimension \eqn{n \times p},
with rows as observations and columns as variables.}

\item{n_spins}{Integer specifying the number of random directions for
directional probing. Larger values increase stability at higher
computational cost.}

\item{robust}{Logical; if \code{TRUE}, robust centering (median) and
scaling (MAD) are applied. If \code{FALSE}, classical centering and
scaling are used.}

\item{cov_adjust}{Logical; if \code{TRUE}, observations are whitened using
a robust or classical covariance estimate (depending on \code{robust})
to remove linear dependence.}

\item{contrib_quantile}{Numeric in \eqn{(0,1)} specifying the quantile
threshold to select influential spinner directions for computing
dimension-level contributions (default 0.90).}

\item{plot_top_n}{Optional integer; if provided and
\code{make_contrib_plot = TRUE}, a stacked bar plot of dimension
contributions is produced for the top \code{plot_top_n} observations.}

\item{make_contrib_plot}{Logical; if \code{TRUE}, generates a stacked bar
plot summarizing dimension-level contributions for the most outlying
observations.}

\item{seed}{Optional integer seed for reproducibility of random spinner
directions.}
}
\value{
A list with the following components:
\describe{
\item{score}{Numeric vector of length \eqn{n} with Spinner outlier scores.}
\item{score_align}{Numeric vector capturing angular alignment per observation.}
\item{mean_proj}{Mean absolute projection per observation across all spinner directions.}
\item{proj_matrix}{Matrix of signed projections of observations onto spinner directions.}
\item{dim_contrib_raw}{Matrix of raw dimension-level contributions per observation.}
\item{dim_contrib_norm}{Row-normalized contributions, interpretable as relative attribution weights.}
\item{top_spins}{List of influential spinner directions selected for each observation.}
\item{contrib_plot}{A \code{ggplot2} object showing contributions for the most extreme observations, or \code{NULL}.}
\item{n_spins}{Number of random directions used.}
\item{robust_center}{Vector of location estimates used for centering.}
\item{cov_adjust}{Logical indicating whether covariance adjustment was applied.}
}
}
\description{
Computes multivariate outlier scores using random directional probing
of standardized observations. The method captures both radial extremeness
and angular alignment by projecting observations onto multiple random
directions ("spins") and aggregating projection-based deviations.
}
\details{
In addition to a global outlier score, the function provides
dimension-level contribution measures that attribute each observation's
outlyingness to the original variables, enabling post hoc interpretability.

Robust centering, scaling, and optional covariance adjustment ensure
affine invariance and resistance to marginal contamination.

The Spinner score combines two complementary components:
\enumerate{
\item Radial deviation, measured as squared deviations of projections
from their marginal centers.
\item Angular alignment, capturing whether an observation consistently
aligns with specific directions in high-dimensional space.
}
Dimension-level contributions are computed by backprojecting influential
spinner directions to the original coordinate system. Only directions
with large projection magnitudes are retained, preserving rotational
invariance while enabling interpretability.

The method is motivated by ongoing research. A detailed theoretical
treatment and empirical evaluation are provided in a manuscript
currently under review.
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), ncol = 4)
res <- spinner_outlier_score(
  X,
  n_spins = 100,
  robust = TRUE,
  cov_adjust = TRUE,
  contrib_quantile = 0.9,
  plot_top_n = 3,
  make_contrib_plot = TRUE
)
head(res$score)
if (!is.null(res$contrib_plot)) print(res$contrib_plot)

}
\references{
Economou, P. (2026). \emph{Spinner: A Geometric Multivariate Outlier
Detection Method Using Random Directional Probing}. Manuscript under review.
}
