% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_level_functions.R
\name{batchrun}
\alias{batchrun}
\title{Running pKSEA::compare() on multiple files}
\usage{
batchrun(summaryfiledir, commonfilestring = ".csv",
predictionDB, results_folder = NULL, ...)
}
\arguments{
\item{summaryfiledir}{Directory containing summary statistic CSV files. Required data file columns:
GN = gene name identifier that will be matched with prediction database, Peptide = unique peptide identifier
(for example, sequence with modifications), Phosphosites = comma-separated phosphorylation sites (eg. "T102,S105"),
pval= pairwise test p-value, fc= mean fold change, t= pairwise test t-statistic. pval and fc are used for results
reporting only, all others are important for database searching, calculation, and permutation testing.}

\item{commonfilestring}{Common string identifying all files to be included in analysis}

\item{predictionDB}{Input database whose prediction scores will be used for calculations. Required columns:
substrate_name= name of substrate corresponding to GN in summary_data, kinase_id = identifiers for kinase predictors,
position= phosphorylated residue number, score = numeric score for strength of prediction.}

\item{results_folder}{if desired, a single output folder. Else each run performed on each file
will have a separate output folder identified by run initiation time.}

\item{...}{parameters to be passed on to downstream functions, including(default): outputpath (tempdir())
n_permutations (1000), seed (123), kseadb (NULL), kin_ens_table (NULL).
See \code{\link{run_on_matched}}, \code{\link{compare}} for details.}
}
\description{
For running compare() on multiple CSV data files in the same directory and for writing results to a folder in the
designated data directory. Can receive various arguments to be passed on to downstream functions. Writes to tempdir()
unless \code{outputpath} variable is specified by user (argument passed on to \code{\link{results_write}}).
}
\examples{
#point to data directory that contains summary .csv files
datapath <- system.file("extdata", package = "pKSEA")

#run batchrun function to analyze all files in that folder, with options
batchrun(datapath, predictionDB=NetworKINPred_db, kseadb = KSEAdb, n_permutations = 5)
}
