% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_inspection.R
\name{check_sum_vars}
\alias{check_sum_vars}
\title{Check sum variables}
\usage{
check_sum_vars(..., df, outcome, digits = 3)
}
\arguments{
\item{...}{character vector. This character vector contains the name of the variables of which the sum will be checked.}

\item{df}{a dataframe.}

\item{outcome}{character string. Name of variable of the dataframe which should equal the sum of variables mentioned in `...`.}

\item{digits}{Define the number of digits at which the sum and the `outcome` variables are rounded. Default is 3 digits.}
}
\value{
A string.
}
\description{
This function tests whether the sum of selected variables are equal to another.
}
\examples{
# Checking whether health state and adverse event costs equal the total discounted costs
check_sum_vars("t_costs_pfs_d_int", "t_costs_pd_d_int", "t_costs_ae_int",
               df = head(df_pa),
               outcome = "t_costs_d_int",
               digits = 0)
}
