% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_lifeduration}
\alias{pac_lifeduration}
\title{Package version life duration at specific Date or for a specific version}
\usage{
pac_lifeduration(
  pac,
  version = NULL,
  at = NULL,
  lib.loc = .libPaths(),
  repos = biocran_repos(),
  source = c("cran", "crandb")
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{at}{\code{Date} from which to take the version. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}

\item{source}{\code{character} one of \code{c("cran", "crandb")}.
Using the \verb{MEATCRAN CRANDB} or the direct web page download from CRAN.
When \code{"crandb"} is set then \code{options(pacs.crandb_ntry = 3)} and \code{options(pacs.crandb_nsleep = 0.001)} can be used to control the fetch.
\code{"pacs.crandb_ntry"} can be used to set the maximum number of try outs, by default 3.
\code{"pacs.crandb_nsleep"} can be used to set the sleep duration between fetch try outs, by default 0.001.
Default: \code{"cran"}}
}
\value{
\code{difftime}, number of days package version was the newest one.
}
\description{
a package life duration for a certain version or at a specific Date.
By default works for the newest package version.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_lifeduration("memoise")
pacs::pac_lifeduration("memoise", source = "cran")
pacs::pac_lifeduration("dplyr", version = "0.8.0")
pacs::pac_lifeduration("dplyr", at = as.Date("2019-02-14"))
# For Bioconductor packages it will work only for the newest per R version and installed ones.
pacs::pac_lifeduration("S4Vectors")
}
}
