## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----match_success_rate_n_rel, echo=FALSE, fig.cap='Fig. 2: Relative match success rate in number of loans by different bank types. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_match_success_rate_rel_n_bank_type.png")

## ----match_success_rate_n_abs, echo=FALSE, fig.cap='Fig. 3: Absolute match success rate in number of loans by different bank types. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_match_success_rate_abs_n_bank_type.png")

## ----match_success_rate_outstanding_rel, echo=FALSE, fig.cap='Fig. 4: Relative match success rate in number of loans aggregated over all loan books. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_match_success_rate_rel_outstanding_meta.png")

## ----match_success_rate_outstanding_abs, echo=FALSE, fig.cap='Fig. 5: Absolute match success rate in number of loans aggregated over all loan books. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_match_success_rate_abs_outstanding_meta.png")

## ----tech_mix_auto, echo=FALSE, fig.cap='Fig. 6: Technology mix for the automotive sector of a loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_tech_mix_automotive_meta.png")

## ----tech_mix_power, echo=FALSE, fig.cap='Fig. 7: Technology mix for the power generation sector of a loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_tech_mix_power_meta.png")

## ----trajectory_auto_ev, echo=FALSE, fig.cap='Fig. 8: Volume trajectory plot for electric vehicle production in the automotive sector of a loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_trajectory_automotive_electric_meta.png")

## ----trajectory_coal_mining, echo=FALSE, fig.cap='Fig. 9: Volume trajectory plot for for coal mining (technology and sector) of a loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_trajectory_coal_coal_meta.png")

## ----emission_intensity_cement, echo=FALSE, fig.cap='Fig. 10: Emission intensity pathway plot for cement production of companies in the loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_emission_intensity_cement_meta.png")

## ----emission_intensity_steel, echo=FALSE, fig.cap='Fig. 11: Emission intensity pathway plot for steel production of companies in the loan book. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_emission_intensity_steel_meta.png")

## ----sankey, echo=FALSE, fig.cap='Fig. 12: Sankey plot of the aggregated loan books by sector and by net aggregate alignment metric. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_sankey_sector.png")

## ----alignment_by_exposure, echo=FALSE, fig.cap='Fig. 13: Alignment by exposure plot of loan books grouped by bank type. Data is based on simulated test loan books.', fig.align='center', out.width='80%'----
knitr::include_graphics("../man/figures/plot_scatter_alignment_exposure_bank_type.png")

## ----scatter_bo_po_loan_book, echo=FALSE, fig.cap='Fig. 14: Scatter plot showing the buildout/phaseout disaggregation of the net aggregate alignment metric in the automotive sector by bank type at the loan book level. Data is based on simulated test loan books.', fig.align='center', out.width='100%'----
knitr::include_graphics("../man/figures/plot_scatter_automotive_by_bank_type.png")

## ----scatter_bo_po_company, echo=FALSE, fig.cap='Fig. 15: Scatter plot showing the buildout/phaseout disaggregation of the net aggregate alignment metric in the automotive sector for less significant fiancial institutions at the company level. Data is based on simulated test loan books.', fig.align='center', out.width='100%'----
knitr::include_graphics("../man/figures/plot_scatter_automotive_company_by_bank_type_less_significant.png")

