% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{gemini_create_batch}
\alias{gemini_create_batch}
\title{Create a Gemini Batch job from request objects}
\usage{
gemini_create_batch(
  requests,
  model,
  api_key = Sys.getenv("GEMINI_API_KEY"),
  api_version = "v1beta",
  display_name = NULL
)
}
\arguments{
\item{requests}{List of GenerateContent request objects, each of the form
\code{list(contents = ..., generationConfig = ...)}. You can obtain this
list from the output of \code{\link{build_gemini_batch_requests}} via
\code{batch$request}.}

\item{model}{Gemini model name, for example \code{"gemini-3-pro-preview"}.}

\item{api_key}{Optional Gemini API key. Defaults to
\code{Sys.getenv("GEMINI_API_KEY")}.}

\item{api_version}{API version string for the path; defaults to
\code{"v1beta"}.}

\item{display_name}{Optional display name for the batch.}
}
\value{
A list representing the Batch job object returned by Gemini.
Important fields include \code{name}, \code{metadata$state},
and (after completion) \code{response$inlinedResponses} or
\code{response$responsesFile}.
}
\description{
This is a thin wrapper around the REST endpoint
\code{/v1beta/models/<MODEL>:batchGenerateContent}. It accepts a list of
GenerateContent request objects and returns the created Batch job.
}
\details{
Typically you will not call this directly; instead, use
\code{\link{run_gemini_batch_pipeline}} which builds requests from a tibble
of pairs, creates the batch, polls for completion, and parses the results.
}
\examples{
# --- Offline preparation: build GenerateContent requests ---

data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 2, seed = 123)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

batch_tbl <- build_gemini_batch_requests(
  pairs             = pairs,
  model             = "gemini-3-pro-preview",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  thinking_level    = "low"
)

# Extract the list of request objects
requests <- batch_tbl$request

# Inspect a single GenerateContent request (purely local)
requests[[1]]

# --- Online step: create the Gemini Batch job ---
# Requires network access and a valid Gemini API key.
\dontrun{
batch <- gemini_create_batch(
  requests = requests,
  model    = "gemini-3-pro-preview"
)

batch$name
batch$metadata$state
}

}
