% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{gemini_poll_batch_until_complete}
\alias{gemini_poll_batch_until_complete}
\title{Poll a Gemini Batch job until completion}
\usage{
gemini_poll_batch_until_complete(
  batch_name,
  interval_seconds = 60,
  timeout_seconds = 86400,
  api_key = Sys.getenv("GEMINI_API_KEY"),
  api_version = "v1beta",
  verbose = TRUE
)
}
\arguments{
\item{batch_name}{Character scalar giving the batch name.}

\item{interval_seconds}{Polling interval in seconds. Defaults to 60.}

\item{timeout_seconds}{Maximum total waiting time in seconds. Defaults to
24 hours (86400 seconds).}

\item{api_key}{Optional Gemini API key. Defaults to
\code{Sys.getenv("GEMINI_API_KEY")}.}

\item{api_version}{API version string for the path; defaults to
\code{"v1beta"}.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.}
}
\value{
The final Batch job object as returned by
\code{\link{gemini_get_batch}}.
}
\description{
This helper repeatedly calls \code{\link{gemini_get_batch}} until the
batch's \code{metadata$state} enters a terminal state or a time limit is
reached. For the REST API, states have the form "BATCH_STATE_*".
}
\examples{
# Offline: polling parameters and batch name are plain R objects
batch_name <- "batches/123456"

# Online: poll until the batch reaches a terminal state (requires network)
\dontrun{
final_batch <- gemini_poll_batch_until_complete(
  batch_name       = batch_name,
  interval_seconds = 10,
  timeout_seconds  = 600,
  verbose          = TRUE
)
final_batch$metadata$state
}

}
