% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairing.R
\name{make_pairs}
\alias{make_pairs}
\title{Create all unordered pairs of writing samples}
\usage{
make_pairs(samples)
}
\arguments{
\item{samples}{A tibble or data frame with columns \code{ID} and \code{text}.}
}
\value{
A tibble with columns:
\itemize{
\item \code{ID1}, \code{text1}
\item \code{ID2}, \code{text2}
}
}
\description{
Given a data frame of samples with columns \code{ID} and \code{text},
this function generates all unordered pairs (combinations) of samples.
Each pair appears exactly once, with \code{ID1} < \code{ID2} in
lexicographic order.
}
\examples{
samples <- tibble::tibble(
  ID   = c("S1", "S2", "S3"),
  text = c("Sample 1", "Sample 2", "Sample 3")
)

pairs_all <- make_pairs(samples)
pairs_all

# Using the built-in example data
data("example_writing_samples")
pairs_example <- make_pairs(example_writing_samples)
nrow(pairs_example) # should be choose(10, 2) = 45

}
