% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimestepAbundances.R
\name{getTimestepAbundances}
\alias{getTimestepAbundances}
\title{Simulate Fossil Assemblages with Abundances at each Time-Step}
\usage{
getTimestepAbundances(
  kdeRescaled,
  probSpeciesOccur,
  gradientValues,
  specimensPerTimestep
)
}
\arguments{
\item{kdeRescaled}{The list of modeled KDEs for species abundance, output from \code{\link{getSpeciesSpecificRescaledKDE}}.}

\item{probSpeciesOccur}{The output from \code{\link{getProbOccViaPresAbs}}}

\item{gradientValues}{A vector of gradient values to simulate over. A separate 'true' assemblage / community will be simulated for each value in the respective vector.}

\item{specimensPerTimestep}{The number of specimens returned in a given time-step by \code{getTimestepAbundances}, usually set to an unrealistically high number to represent the true 'unsampled' fossil assemblage.}
}
\value{
A matrix containing abundances for species as a series of simulated assemblages.
}
\description{
Given a set of KDEs fit to species abundance and models of species occurrence relative to an environmental gradient, and given a sequence of gradient values, and a number of specimens to sample at each time-step, obtains a matrix containing abundances for species as a series of simulated assemblages.
}
\details{
\code{getTimestepAbundances} represents simulating the original biotic community that was present at some given point in time, which is not the same thing as a fossil assemblage that might be collected from sediments today as finite samples. That is covered by feeding the output from this function to \code{sampleFossilSeries}.

Thus, this function is generally run before running \code{\link{sampleFossilSeries}}, 
however most users will likely never run either function, 
instead running \code{\link{simulateFossilAssemblageSeries}}.
}
\seealso{
This function is generally run before running \code{\link{sampleFossilSeries}}. 
Most users will likely never run either function, instead running \code{\link{simulateFossilAssemblageSeries}}.
}
