% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_temporal_functions.R
\name{pbdb_orig_ext}
\alias{pbdb_orig_ext}
\title{Appearance of new taxa and extinctions across time}
\usage{
pbdb_orig_ext(
  data,
  rank = c("species", "genus", "family", "order", "class", "phylum"),
  temporal_extent,
  res,
  orig_ext = 1,
  colour = "#0000FF30",
  bord = "#0000FF",
  ylab = NULL,
  do_plot = TRUE
)
}
\arguments{
\item{data}{Data frame from a query to PaleobioDB as returned by
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}}.  Important: it is required to
show the name of the families, orders, etc. in the data frame, to
do that set: \code{show = c("classext", "ident")} (see Examples).}

\item{rank}{The taxon rank to be analyzed. Its default value is
\code{"species"}.}

\item{temporal_extent}{Vector to set the temporal extent (min, max)}

\item{res}{Numeric. Sets the intervals of the temporal extent.}

\item{orig_ext}{Set to 1 to plot the number new appearances, or to
2 to plot the number of extinctions.}

\item{colour}{Colour of the area of the polygon in the plot.}

\item{bord}{Colour of the border of the polygon.}

\item{ylab}{A label for the y axis.}

\item{do_plot}{Logical value indicating whether to produce a plot
(\code{TRUE} by default).}
}
\value{
A data frame with the number of first appearances and
extinctions of the selected taxon rank across time.
}
\description{
Returns a data frame with the appearance of new taxa and their last
appearances across time in the provided data and optionally
produces a plot from it, showing the new appearances or last
appearances.
}
\examples{
\dontrun{
  canidae <- pbdb_occurrences(
    limit = "all", vocab = "pbdb",
    base_name = "Canidae", show = "classext"
  )

  # Plot of the evolutionary rates
  pbdb_orig_ext(
    canidae,
    rank = "genus",
    orig_ext = 1,
    temporal_extent = c(0, 10), res = 1
  )

  # Plot of the extinction rates
  pbdb_orig_ext(
    canidae,
    rank = "genus",
    orig_ext = 2,
    temporal_extent = c(0, 10), res = 1
  )
}
}
