% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales_discrete.R
\name{scale_colour_paletteer_d}
\alias{scale_colour_paletteer_d}
\alias{scale_color_paletteer_d}
\alias{scale_fill_paletteer_d}
\title{Discrete scales to use for ggplot2}
\usage{
scale_colour_paletteer_d(palette, direction = 1, dynamic = FALSE, ...)

scale_color_paletteer_d(palette, direction = 1, dynamic = FALSE, ...)

scale_fill_paletteer_d(palette, direction = 1, dynamic = FALSE, ...)
}
\arguments{
\item{palette}{Name of palette as a string. Must be on the form
packagename::palettename.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{dynamic}{toggles between the discrete palettes and the dynamic
palettes. Defaults to FALSE which indicates discrete palettes.}

\item{...}{additional arguments to pass to discrete_scale}
}
\description{
These functions provide the option to use the discrete and dynamic palettes
along with the \code{ggplot2} package. It goes without saying that it requires
\code{ggplot2} to work.
}
\details{
Available package/palette combinations are available in the data.frame
\code{\link[paletteer]{palettes_d_names}} and
\code{\link[paletteer]{palettes_dynamic_names}}.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
library(ggplot2)
ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, colour = Species)) +
  geom_point() +
  scale_colour_paletteer_d("nord::frost")
\dontshow{\}) # examplesIf}
}
