% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Insol.R
\name{Milankovitch}
\alias{Milankovitch}
\title{Milankovitch graph for a given astronomical configuration}
\usage{
Milankovitch(
  orbit,
  S0 = 1365,
  lat = seq(-pi/2, pi/2, l = 73),
  long = seq(0, 2 * pi, l = 145),
  deg = TRUE
)
}
\arguments{
\item{orbit}{Output from a solution, such as \code{ber78}, \code{ber90} or
\code{la04}}

\item{S0}{Total solar irradiance}

\item{lat}{latitudes, passed as an array}

\item{long}{true solar longitudes, passed as an array}

\item{deg}{If true : the axes of the Milankovitch object are expressed in
degrees.  Inputs are always in radians}
}
\value{
A object of Milankovitch class, which may be plotted using the
regular plot function
}
\description{
Computes the distrubition in latitude and longitude of incoming solar
radiation, known as a Milankovitch graph, with possibility of plotting with
a dedicated plot function
}
\note{
The polar night option may not be bullet-proof for exotic obliquities
}
\examples{

orbit <- c(eps=0.409214, ecc=0.01672393, varpi=4.92251)
M <- Milankovitch(orbit)
plot(M, plot=contour)
plot(M, plot=contour, month=FALSE)

}
\references{
Berger, A. L. (1978).  Long-term variations of daily insolation
and Quaternary climatic changes, J. Atmos. Sci., 35, 2362-2367.
}
\author{
Michel Crucifix, U. catholique de Louvain, Belgium.
}
\keyword{misc}
