% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-list.R
\name{pandoc_list_extensions}
\alias{pandoc_list_extensions}
\title{List supported extensions for a format}
\usage{
pandoc_list_extensions(format = "markdown", version = "default")
}
\arguments{
\item{format}{One for the supported  \code{input} or \code{output} formats. See \code{\link[=pandoc_list_formats]{pandoc_list_formats()}}. It corresponds to call}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
a data.frame (or a tibble if available) with 3 columns:
\itemize{
\item \code{format}: One of the Pandoc format
\item \code{extensions} : name of the extensions
\item \code{default}: Is the extensions activated by default or not ?
}
}
\description{
Pandoc has a system of extensions to activate or deactivate some features.
Each format have a set of activated by default extensions and other supported
extensions than can be activated.
}
\details{
All the extensions for the last Pandoc version released are available in
\url{https://pandoc.org/MANUAL.html}.
}
\examples{
\dontshow{if (pandoc_available("2.8")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc_list_extensions("markdown")
pandoc_list_extensions("gfm")
\dontshow{\}) # examplesIf}
\dontshow{if (!is.null(pandoc::pandoc_system_bin()) && pandoc_system_version() > "2.8") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# target a specific version
pandoc_list_extensions("html", version = "system")
\dontshow{\}) # examplesIf}
}
