% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_causal.R
\name{causal_config}
\alias{causal_config}
\title{Returns the configuration of a causal model}
\usage{
causal_config(
  model = getOption("pangoling.causal.default"),
  checkpoint = NULL,
  config_model = NULL
)
}
\arguments{
\item{model}{Name of a pre-trained model or folder. One should be able to use
models based on "gpt2". See
\href{https://huggingface.co/models?other=gpt2}{hugging face website}.}

\item{checkpoint}{Folder of a checkpoint.}

\item{config_model}{List with other arguments that control how the
model from Hugging Face is accessed.}
}
\value{
A list with the configuration of the model.
}
\description{
Returns the configuration of a causal model
}
\section{More details about causal models}{

A causal language model (also called GPT-like, auto-regressive, or decoder
model) is a type of large language model usually used for text-generation
that can predict the next word (or more accurately in fact token) based
on a preceding context.

If not specified, the causal model used will be the one set in the global
option \code{pangoling.causal.default}, this can be
accessed via \code{getOption("pangoling.causal.default")} (by default
"gpt2"). To change the default option
use \code{options(pangoling.causal.default = "newcausalmodel")}.

A list of possible causal models can be found in
\href{https://huggingface.co/models?pipeline_tag=text-generation}{Hugging Face website}.

Using the  \code{config_model} and \code{config_tokenizer} arguments, it's possible to
control how the model and tokenizer from Hugging Face is accessed, see the
Python method
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoProcessor.from_pretrained}{\code{from_pretrained}}
for details.

In case of errors when a new model is run, check the status of
\url{https://status.huggingface.co/}
}

\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
causal_config(model = "gpt2")
\dontshow{\}) # examplesIf}
}
\seealso{
Other causal model helper functions: 
\code{\link{causal_preload}()}
}
\concept{causal model helper functions}
