% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sampler1D.R
\name{Sampler1DCateg}
\alias{Sampler1DCateg}
\title{Sampler1DCateg Class}
\description{
Sampling from a discrete distribution, for a \code{\link{ParamSet}} containing a single \code{\link[=p_fct]{p_fct()}} or \code{\link[=p_lgl]{p_lgl()}}.
}
\seealso{
Other Sampler: 
\code{\link{Sampler}},
\code{\link{Sampler1D}},
\code{\link{Sampler1DNormal}},
\code{\link{Sampler1DRfun}},
\code{\link{Sampler1DUnif}},
\code{\link{SamplerHierarchical}},
\code{\link{SamplerJointIndep}},
\code{\link{SamplerUnif}}
}
\concept{Sampler}
\section{Super classes}{
\code{\link[paradox:Sampler]{paradox::Sampler}} -> \code{\link[paradox:Sampler1D]{paradox::Sampler1D}} -> \code{Sampler1DCateg}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{prob}}{(\code{numeric()} | NULL)\cr
Numeric vector of \code{param$nlevels} probabilities.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Sampler1DCateg-new}{\code{Sampler1DCateg$new()}}
\item \href{#method-Sampler1DCateg-clone}{\code{Sampler1DCateg$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="format"><a href='../../paradox/html/Sampler.html#method-Sampler-format'><code>paradox::Sampler$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="print"><a href='../../paradox/html/Sampler.html#method-Sampler-print'><code>paradox::Sampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="Sampler" data-id="sample"><a href='../../paradox/html/Sampler.html#method-Sampler-sample'><code>paradox::Sampler$sample()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Sampler1DCateg-new"></a>}}
\if{latex}{\out{\hypertarget{method-Sampler1DCateg-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sampler1DCateg$new(param, prob = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{(\code{\link{ParamSet}})\cr
Domain / support of the distribution we want to sample from.
Must be one-dimensional.}

\item{\code{prob}}{(\code{numeric()} | NULL)\cr
Numeric vector of \code{param$nlevels} probabilities, which is uniform by default.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Sampler1DCateg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Sampler1DCateg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sampler1DCateg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
