% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reinflateFac}
\alias{reinflateFac}
\title{Calculate Xhat from a model Fac object}
\usage{
reinflateFac(Fac, X, returnAsTensor = FALSE)
}
\arguments{
\item{Fac}{Fac object from parafac}

\item{X}{Input data X}

\item{returnAsTensor}{Boolean to return Xhat as rTensor tensor (TRUE) or matrix (default, FALSE).}
}
\value{
Xhat
}
\description{
Calculate Xhat from a model Fac object
}
\examples{
processedFujita = processDataCube(Fujita2023, sparsityThreshold=0.99, centerMode=1, scaleMode=2)
model = parafac(processedFujita$data, nfac=1, nstart=1)
Xhat = reinflateFac(model$Fac, processedFujita$data)
}
