% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{distill}
\alias{distill}
\title{Distill Outcomes}
\usage{
distill(alembic_dt, outcomes_dt, groupcol = names(outcomes_dt)[1])
}
\arguments{
\item{alembic_dt}{an \code{\link[=alembic]{alembic()}} return value}

\item{outcomes_dt}{a long-format \code{data.frame} with a column either named
\code{from} or \code{model_from} and a column \code{value} (other columns will be silently
ignored)}

\item{groupcol}{a string, the name of the outcome model group column. The
\code{outcomes_dt[[groupcol]]} column must match the \code{model_partition} lower
bounds, as provided when constructing the \code{alembic_dt} with \code{\link[=alembic]{alembic()}}.}
}
\value{
a \code{data.frame}, with \code{output_partition} and recalculated \code{value} column
}
\description{
\code{distill} takes a low-age resolution outcome, for example deaths,
and proportionally distributes that outcome into a higher age resolution for
use in subsequent analyses like years-life-lost style calculations.
}
\details{
When the \code{value} column is re-calculated, note that it will aggregate all
rows with matching \code{groupcol} entries in \code{outcomes_dt}. If you need to group
by other features in your input data (e.g. if you need to distill outcomes
across multiple simulation outputs or at multiple time points), that has to
be done by external grouping then calling \code{distill()}.
}
\examples{
\dontshow{if (require(data.table)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

ifr_levin <- function(age_in_years) {
  (10^(-3.27 + 0.0524 * age_in_years))/100
}

age_limits <- c(seq(0, 69, by = 5), 70, 80, 101)
age_pyramid <- data.frame(
  from = 0:101, weight = ifelse(0:101 < 65, 1, .99^(0:101-64))
)
age_pyramid$weight[102] <- 0
# flat age distribution, then 1\% annual deaths, no one lives past 101

alembic_dt <- alembic(ifr_levin, age_pyramid, age_limits, 0:101)

results <- data.frame(model_partition = head(age_limits, -1))
results$value <- 10
distill(alembic_dt, results)
\dontshow{\}) # examplesIf}
}
